---@meta

---@class AARPassthroughManager : AActor
---@field ARComponentClasses TArray<TSubclassOf<UARComponent>>
---@field PassthroughUpdateComponent UPassthroughMaterialUpdateComponent
local AARPassthroughManager = {}

---@return UPassthroughMaterialUpdateComponent
function AARPassthroughManager:GetPassthroughMaterialUpdateComponent() end


---@class FARKitPoseTrackingConfig
---@field HumanForward FVector
---@field MeshForward FVector
local FARKitPoseTrackingConfig = {}



---@class UARLiveLinkRetargetAsset : ULiveLinkRetargetAsset
---@field SourceType EARLiveLinkSourceType
---@field BoneMap TMap<FName, FName>
---@field ARKitPoseTrackingConfig FARKitPoseTrackingConfig
local UARLiveLinkRetargetAsset = {}



---@class UARUtilitiesFunctionLibrary : UBlueprintFunctionLibrary
local UARUtilitiesFunctionLibrary = {}

---@param MaterialInstance UMaterialInstanceDynamic
---@param WorldToMeterScale float
function UARUtilitiesFunctionLibrary:UpdateWorldToMeterScale(MaterialInstance, WorldToMeterScale) end
---@param MaterialInstance UMaterialInstanceDynamic
---@param SceneDepthTexture UTexture
---@param DepthToMeterScale float
function UARUtilitiesFunctionLibrary:UpdateSceneDepthTexture(MaterialInstance, SceneDepthTexture, DepthToMeterScale) end
---@param MaterialInstance UMaterialInstanceDynamic
---@param CameraTexture UTexture
---@param ColorScale float
function UARUtilitiesFunctionLibrary:UpdateCameraTextureParam(MaterialInstance, CameraTexture, ColorScale) end


---@class UPassthroughMaterialUpdateComponent : UActorComponent
---@field TextureType EARTextureType
---@field PassthroughMaterial UMaterialInterface
---@field PassthroughMaterialExternalTexture UMaterialInterface
---@field PassthroughDebugColor FLinearColor
---@field AffectedComponents TArray<UPrimitiveComponent>
---@field PendingComponents TArray<UPrimitiveComponent>
local UPassthroughMaterialUpdateComponent = {}

---@param NewDebugColor FLinearColor
function UPassthroughMaterialUpdateComponent:SetPassthroughDebugColor(NewDebugColor) end
---@param InComponent UPrimitiveComponent
function UPassthroughMaterialUpdateComponent:RemoveAffectedComponent(InComponent) end
---@param InComponent UPrimitiveComponent
function UPassthroughMaterialUpdateComponent:AddAffectedComponent(InComponent) end


